package com.ejie.p06b.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;

import com.ejie.p06b.datatype.model.P06B43T00Datatype;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BFecha;
import com.ejie.p06b.util.bd.P06BServidorConexionesBD;

/**
 * Fecha de creacin: (26/01/2012)
 */
public class P06B43T00DAO {
	
	static private P06B43T00DAO instance = null;

	public static P06B43T00DAO getInstance() {
	     if (instance == null) {
	          synchronized (P06B43T00DAO.class) {
	          		if (instance == null) {
	                     instance = new P06B43T00DAO();
	                }
	          }
	     }
	     return instance;
	}
	
	/**
    * Obtiene la lista de entidades vinculadas del Modelo 0 de la DEC, asociadas al expediente y ejercicio
    * @param ejer.
    * @param numExp          
    * @return Lista de objetos entidades vinculadas DEC Modelo 0
	 * @throws Exception
    */
	public ArrayList selectAllByEjerExp(String ejer, String numExp) throws Exception{
		P06BLog.send(2,this, "Inicio P06B43T00DAO-selectAllByEjerExp");
		ArrayList lista = new ArrayList();
		P06B43T00Datatype obj = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECTALL_BY_EJEREXP;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,ejer.toUpperCase());
        	lstm.setString(2,numExp.toUpperCase());
        	lrst = lstm.executeQuery();
	        while (lrst.next()) {
	        	obj = new P06B43T00Datatype();

			    obj.setEjercicio(lrst.getString(P06BTablas.P06B_P06B43_EJERCICIO));
			    obj.setNumExp(lrst.getString(P06BTablas.P06B_P06B43_NUMEXP));
			    obj.setClave(lrst.getString(P06BTablas.P06B_P06B43_CLAVE));
			    obj.setDenom(lrst.getString(P06BTablas.P06B_P06B43_DENOM)==null?"":lrst.getString(P06BTablas.P06B_P06B43_DENOM));
			    obj.setFhInscrip(lrst.getString(P06BTablas.P06B_P06B43_FH_INSCRIP)==null?"":P06BFecha.getFechaFormateada(lrst.getDate(P06BTablas.P06B_P06B43_FH_INSCRIP),new Locale(P06BConstantes.P06B_IDIOMA_ES)));

	        	lista.add(obj);
	        }
	        P06BLog.send(2,this, "Fin P06B43T00DAO-selectAllByEjerExp");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e;
	    }catch (Exception e2) {	 
        	P06BLog.send(2,this, "error: " +e2.getMessage());
        	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	        //Propago la excepcin
	        throw e2;
	    }finally {
	    	try {
        		if(lrst!=null)
        			lrst.close();
        	}catch (Exception rse) {}
	        try {
	        	if(lstm!=null)
	        		lstm.close();
	        }catch (Exception sse) {}
	        try {
	        	if(lconConexion!=null)
	        		lconConexion.close();
	        }catch (Exception cse) {}
	    }
		return lista;
	}
	

	private static String SELECTALL_BY_EJEREXP =
		"SELECT "
		+ P06BTablas.P06B_P06B43_EJERCICIO + ", "
		+ P06BTablas.P06B_P06B43_NUMEXP + ", "
		+ P06BTablas.P06B_P06B43_CLAVE + ", "
		+ P06BTablas.P06B_P06B43_DENOM + ", "
		+ P06BTablas.P06B_P06B43_FH_INSCRIP +
				
		" FROM " + P06BTablas.P06B_P06B43T00_TABLA 
		+ " WHERE " + P06BTablas.P06B_P06B43_EJERCICIO + "= ?" 
			+ " AND " + P06BTablas.P06B_P06B43_NUMEXP + "= ?"
		+" ORDER BY " + P06BTablas.P06B_P06B43_CLAVE ;

}
